/*
 * Decompiled with CFR 0.152.
 */
package graph.generator;

import graph.generator.GraphFunctions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import shared.Pair;
import shared.Table;

class PairGenerator {
    private static GraphFunctions.GFunction function;
    private final ArrayList<String> items;
    private final ArrayList<String> attributes;
    private final ArrayList<ArrayList<Float>> values;
    private final HashSet<Float> possibleValues;
    private final ArrayList<Pair> pairs;

    protected PairGenerator(Table table, GraphFunctions.GFunction fun) {
        function = fun;
        this.pairs = new ArrayList();
        this.possibleValues = table.getPossibleValues();
        this.items = table.getUnlockedItemsList();
        this.attributes = table.getUnlockedAttributesList();
        this.values = table.getUnlockedValuesList();
    }

    protected static GraphFunctions.GFunction getFunction() {
        return function;
    }

    protected ArrayList<Pair> generatePairs() {
        int colNumber = this.items.size();
        long rowsNumber = (long)Math.pow(this.possibleValues.size(), this.items.size());
        Row row = new Row(this.possibleValues, colNumber);
        int i = 0;
        while ((long)i < rowsNumber) {
            switch (function) {
                case CLASSIC: {
                    ArrayList<Float> result = GraphFunctions.classic(row.getArray(), this.values);
                    if (!result.contains(Float.valueOf(1.0f)) && row.getArray().contains(Float.valueOf(0.0f))) break;
                    this.addPair(this.items, row.getArray(), this.attributes, result);
                    break;
                }
                case IMPLY: {
                    this.createFuzzyPair(row.getArray(), false);
                }
            }
            row.increment();
            ++i;
        }
        return this.pairs;
    }

    private void addPair(ArrayList<String> itm, ArrayList<Float> itmVal, ArrayList<String> atr, ArrayList<Float> atrVal) {
        int i;
        Pair p = new Pair();
        for (i = 0; i < itm.size(); ++i) {
            p.addItem(itm.get(i), itmVal.get(i).floatValue());
        }
        for (i = 0; i < atr.size(); ++i) {
            p.addAttribute(atr.get(i), atrVal.get(i).floatValue());
        }
        this.pairs.add(p);
    }

    private ArrayList<Float> createFuzzyPair(ArrayList<Float> row, boolean type) {
        ArrayList<Float> result = new ArrayList<Float>();
        int stop = !type ? this.values.get(0).size() : this.values.size();
        for (int i = 0; i < stop; ++i) {
            result.add(this.getImplValue(row, i, type));
        }
        if (!type && row.equals(this.createFuzzyPair(result, true))) {
            this.addPair(this.items, row, this.attributes, result);
        }
        return result;
    }

    private Float getImplValue(ArrayList<Float> row, int j, boolean t) {
        Float min = GraphFunctions.imply(row.get(0), !t ? this.values.get(0).get(j) : this.values.get(j).get(0));
        for (int i = 1; i < row.size(); ++i) {
            Float tmp = GraphFunctions.imply(row.get(i), !t ? this.values.get(i).get(j) : this.values.get(j).get(i));
            if (!(tmp.floatValue() < min.floatValue())) continue;
            min = tmp;
        }
        return min;
    }

    private class Row {
        private Value[] items;

        public Row(Collection<? extends Float> collection, int rowLenght) {
            this.items = new Value[rowLenght];
            for (int i = 0; i < rowLenght; ++i) {
                this.items[i] = new Value(collection);
            }
        }

        public void increment() {
            boolean overflow;
            int temp = this.items.length - 1;
            while ((overflow = this.items[temp].increment()) && --temp >= 0) {
            }
        }

        public Float get(int index) {
            return this.items[index].getCurrent();
        }

        public int size() {
            return this.items.length;
        }

        public ArrayList<Float> getArray() {
            ArrayList<Float> result = new ArrayList<Float>();
            for (int i = 0; i < this.items.length; ++i) {
                result.add(this.items[i].getCurrent());
            }
            return result;
        }

        public String toString() {
            String result = "";
            for (Value v : this.items) {
                result = result + v.toString() + ", ";
            }
            return result;
        }
    }

    private class Value {
        private int index;
        private ArrayList<Float> items = new ArrayList();

        public Value(Collection<? extends Float> collection) {
            this.items.addAll(collection);
            this.index = 0;
        }

        public boolean increment() {
            this.index = (this.index + 1) % this.items.size();
            return this.index == 0;
        }

        public Float getCurrent() {
            return this.items.get(this.index);
        }

        public String toString() {
            return this.getCurrent().toString();
        }
    }
}

